this.name        = "ups_slaves"; 
this.author      = "eric walch"; 
this.copyright   = " 2008 the Oolite team."; 
this.description = "Slaves missions of UPS Courier"; 
this.version     = "1.3.2"; 


this.startUp = function()
{
    if (oolite.compareVersion("1.70") > 0)
    {
        // Oolite version is older than 1.70.
        LogWithClass("script."+this.name, "This UPS-Courier missions does not run under Oolite version " + oolite.versionString + " Slave missions are disabled.")
        delete this.missionScreenEnded
        delete this.shipExitedWitchspace
        delete this.shipDockedWithStation
        delete this.shipLaunchedFromStation
    }
}

/* this.tickle is activated at the same points as the legacy script is activated. So it could be on every status. (even EXITTING_WITCHSPACE) Currently this is a good way to set up conclictfree messages that wait on each other. When you do it on docking and you detect there is already an other message shown, you won't get an second change for displaying the message.
Note that besides the tickles that are fired every 10 seconds, there is one just after docking, were status == "STATUS_DOCKED" but guiScreen = "GUI_SCREEN_MAIN". During the further docked tickles, guiScreen depends on the screen you are looking at.
*/

this.shipDockedWithStation = function()
{
// missionVariables.ups_slaverescue is set to "YES" by a scripted pilot.
    if (missionVariables.ups_slaverescue == "YES")
    {
        this.ups_missionoffers()
    }
}

/*
All the screen offers look alike. Therefor I created a function that does the work. With a single call from other parts all the things are set. Currently I do not use music or ships. But when needed you can add then to the parameterlist and in mission.showShipModel();mission.setMusic(). When it has a value is is set and when null it is cleared, like I now do with mission.setBackgroundImage(backGround).
*/
this.missionScreen=function(messageKey, backGround, choiceKey)
{
        mission.showShipModel();mission.setMusic()
	mission.setBackgroundImage(backGround);
	mission.showMissionScreen();
	mission.addMessageTextKey(messageKey);
        if (choiceKey != null) mission.setChoicesKey(choiceKey)
}

this.ups_missionoffers = function()
{
    if (player.dockedStation.isMainStation && guiScreen != "GUI_SCREEN_MISSION")
    {
        if (missionVariables.ups_slaves == "SLAVE" && !mission.choice && !missionVariables.offering)
        {
                this.missionScreen("ups_slave_homeland", "UPS.png", "ups_slave_accepted_yesno")
                missionVariables.offering ="HOMELANDS"
        }
        if (missionVariables.ups_slplanet == system.ID && missionVariables.ups_slaves == "HOMELAND" && !missionVariables.offering)
        {
                missionVariables.ups_slaves = "NOT_NOW"
//              mission.unmarkSystem(missionVariables.ups_slplanet) // this command crashes Oolite 1.70!
                player.call("removeMissionDestination:", missionVariables.ups_slplanet)
                this.missionScreen("ups_slave_homeland2", "UPS.png", null)
                mission.setInstructionsKey() 
                player.awardCargo("Gem-Stones", 15) 
                missionVariables.ups_slcount++
                player.call("increasePassengerReputation")
        }
        if(missionVariables.ups_slaves == "RESCUEOFFER" && system.government > 3 && system.economy < 3 && !missionVariables.offering)
        {
                this.missionScreen("ups_slave_rescueoffer", "UPS.png", "ups_slave_accepted2_yesno")
                missionVariables.offering ="RESCUE"
        }
        if(missionVariables.ups_slaves == "RESCUE" && system.ID == missionVariables.ups_sl2planet && !missionVariables.offering && missionVariables.ups_convoy == "KILLED")
        {
                if(missionVariables.ups_sl2count > 10)
                {
                    this.missionScreen("ups_slave_rescue10", null, null)
                    player.awardCargo("Gem-Stones", 50)
                } 
                else
                {
                    if(missionVariables.ups_sl2count > 0) this.missionScreen("ups_slave_rescue", null, null)
                    else this.missionScreen("ups_slave_rescue0", null, null)
                }
                missionVariables.ups_sl2count = null 
//              mission.unmarkSystem(missionVariables.ups_sl2planet) // this command crashes Oolite 1.70!
                player.call("removeMissionDestination:", missionVariables.ups_sl2planet)
                missionVariables.ups_sl2planet = null
                missionVariables.ups_sl2planetname = null
                missionVariables.ups_convoy = null
                missionVariables.ups_convoy_attack = null
                mission.setInstructionsKey()
                missionVariables.ups_slaves = "NOT_NOW"
        }
        if (missionVariables.ups_slaves == "FINALOFFER" && system.government > 2 && !mission.choice && !missionVariables.offering)
        {
                this.missionScreen("ups_slave_final", null, "ups_slave_accepted_yesno")
                missionVariables.offering ="FINAL"
        }
        if (missionVariables.ups_slaves == "FINAL" && missionVariables.ups_slplanet == system.ID && !missionVariables.offering)
        {
            this.missionScreen("ups_slave_groundbattle", null, null)
            missionVariables.ups_slaves = "GROUNDBATTLE"
            mission.setInstructionsKey("ups_slave_groundbattle_small") 
            missionVariables.ups_slavesrescued = 5
        }
        if (missionVariables.ups_slaves == "DEBRIEFING" && missionVariables.ups_slplanet == system.ID && !missionVariables.offering)
        {
            missionVariables.ups_slaves = "NOT_NOW"
            mission.setInstructionsKey() 
            if(missionVariables.ups_slavesrescued == "5")
            {
                this.missionScreen("ups_slave_debriefing", null, null)
                player.credits += 6000
            }
            else
            {
                if(missionVariables.ups_slavesrescued == "0")
                {
                    this.missionScreen("ups_slave_debriefing2", null, null)
                }
                else
                {
                    this.missionScreen("ups_slave_debriefing1", null, null)
                    player.credits += 4000
                }
            }
            mission.setInstructionsKey() 
            missionVariables.ups_slavereset = "YES"
//          mission.unmarkSystem(missionVariables.ups_slplanet) // this command crashes Oolite 1.70!
            player.call("removeMissionDestination:", missionVariables.ups_slplanet)
        }
    }
    if (player.dockedStation.shipDescription == "Ground Radar" && guiScreen != "GUI_SCREEN_MISSION")
    {
        if ((missionVariables.ups_slaves == "DEBRIEFING" || missionVariables.ups_slaves == "GROUNDBATTLE") && !missionVariables.offering)
        {
            this.missionScreen("ups_slave_trapped", null, null)
            missionVariables.ups_slaves = "FAILED", 
            missionVariables.ups_slavesreset = "YES"
        }
    }
}

this.missionScreenEnded = function()
{
    if (missionVariables.ups_slaverescue == "YES") 
    {
        if (missionVariables.offering == "HOMELANDS")
        {
            if (mission.choice == "YESSlave")
            {
                mission.markSystem(missionVariables.ups_slplanet) 
                mission.clearMissionScreen() 
                mission.resetMissionChoice()
                mission.setInstructionsKey("ups_slave_small") 
                missionVariables.ups_slaves = "HOMELAND" 
                missionVariables.offering = null
            }
            else
            {
                if (mission.choice == "NOSlave")
                { 
                    mission.clearMissionScreen() 
                    mission.resetMissionChoice()
                    missionVariables.ups_slaves = "NOT_NOW" 
                    missionVariables.offering = null
                }
            }
        }
        if (missionVariables.offering == "RESCUE")
        {
            if (mission.choice == "YESSlave")
            {
                mission.markSystem(missionVariables.ups_sl2planet) 
                mission.clearMissionScreen() 
                mission.resetMissionChoice()
                mission.setInstructionsKey("ups_slave_small3") 
                missionVariables.ups_slaves = "RESCUE" 
                missionVariables.offering = null
                missionVariables.ups_sl2count = "0"
                missionVariables.ups_convoy = null 
                missionVariables.ups_convoy_attack = null
            }
            else
            {
                if (mission.choice == "NOSlave")
                { 
                    mission.clearMissionScreen() 
                    mission.resetMissionChoice()
                    missionVariables.ups_slaves = "NOT_NOW" 
                    missionVariables.offering = null
                }
            }
        }
        if (missionVariables.offering == "FINAL")
        {
            if (mission.choice == "YESSlave")
            {
                mission.markSystem(missionVariables.ups_slplanet) 
                mission.clearMissionScreen() 
                mission.resetMissionChoice()
                mission.setInstructionsKey("ups_slave_small2") 
                missionVariables.ups_slaves = "FINAL" 
                missionVariables.offering = null
            }
            else
            {
                if (mission.choice == "NOSlave")
                { 
                    mission.clearMissionScreen() 
                    mission.resetMissionChoice()
                    missionVariables.ups_slaves = "NOT_NOW" 
                    missionVariables.offering = null
                }
            }
        }
        this.ups_missionoffers()
    }
}

/* Defining a function with: "function = setUpShips_ups_slaves()" will lead to a function that is globally within Oolite. Meaning it is also seen by other scripts and therefor should have unique names.  Function defined  by "this.setUpShips_ups_slaves = function()" are only local to the script and will not give name conflicts with other OXP's. Therefor the method below is preferable.*/
this.setUpShips_ups_slaves = function()
{
    if(missionVariables.ups_slaves == "GROUNDBATTLE")
    {
        if(system.ID == missionVariables.ups_slplanet && system.countShipsWithRole("ups_slave_satellite") == 0)
        {
            system.legacy_addShipsAtPrecisely("ups_slave_satellite", 1, "pwp", 0, 0, 1.01) 
            system.legacy_addShipsAtPrecisely("ups_slave_satellite", 1, "pwp", 0, 0.05, 1.01) 
            system.legacy_addShipsAtPrecisely("ups_slave_satellite", 1, "pwp", 0.05, 0, 1.01) 
            system.legacy_addShipsAtPrecisely("ups_slave_satellite", 1, "pwp", 0.05, 0.05, 1.01) 
            missionVariables.ups_satellitecount = "4"
        }
    }
    if(missionVariables.ups_slaves == "RESCUE")
    {
        if(system.ID == missionVariables.ups_sl2planet && system.countShipsWithRole("ups-convoy-l") == 0 && !missionVariables.ups_convoy && !missionVariables.ups_convoy_attack)
        {
            system.legacy_addSystemShips("ups-convoy-l", 1, 0.5) 
        }
    }
}

this.shipExitedWitchspace = function()
{
  if (missionVariables.ups_slaverescue == "YES")
  {
    this.setUpShips_ups_slaves()
    if (!missionVariables.ups_slaves)
    { // selection of a tyarget system for all slave missions. And make sure you don't select a Nova system.
        if(system.government == 2 && system.economy > 5 && !system.goneNova)
        {
            missionVariables.ups_slaves = "NO" 
            missionVariables.ups_slplanet = system.ID 
            missionVariables.ups_slplanetname = ExpandDescription("[%H]") 
            missionVariables.ups_slcount = "0"
        }
    }
    if (missionVariables.ups_slaves == "NOT_NOW" && Math.random() < 0.1){missionVariables.ups_slaves = "NO"}
    if(missionVariables.ups_slaves == "NO")
    {
        if (missionVariables.ups_slaves == "NO" && missionVariables.ups_slcount > 2 && Math.random() > 0.9 && system.government > 2)
        {
            missionVariables.ups_slaves = "FINALOFFER"
        }
        if (missionVariables.ups_slaves == "NO" && system.ID > -1 && Math.random() > 0.75 && system.economy < 3)
        {
            let position = Math.random()*0.8+0.1; system.legacy_addSystemShips("ups-slavecobra", 1, position) 
        }
        if (missionVariables.ups_slaves == "NO" && missionVariables.ups_slcount > 1 && Math.random() > 0.9 && system.government == 2 && !system.goneNova)
        {
            missionVariables.ups_slaves = "RESCUEOFFER"
            missionVariables.ups_sl2planet = system.ID
            missionVariables.ups_sl2planetname = ExpandDescription("[%H]") 
        }
    }
    if (missionVariables.ups_slavesreset == "YES")
    {
//      mission.unmarkSystem(missionVariables.ups_slplanet) // this command crashes Oolite 1.70!
        player.call("removeMissionDestination:", missionVariables.ups_slplanet)
        mission.setInstructionsKey() 
        if (missionVariables.ups_sl2count)
        {player.call("removeMissionDestination:", missionVariables.ups_sl2planet)}
        missionVariables.ups_slavesreset = null 
        missionVariables.ups_slcount = null
        missionVariables.ups_slavesrescue = null
        missionVariables.ups_slaves = null
        missionVariables.ups_slavename = null
        missionVariables.ups_slplanet = null
        missionVariables.ups_slplanetname = null
        missionVariables.ups_slavesrescued = null
        missionVariables.ups_sl2planet = null
        missionVariables.ups_sl2planetname = null
    }
  }
}

this.shipLaunchedFromStation = function()
{
  if (missionVariables.ups_slaverescue == "YES")
  {
    this.setUpShips_ups_slaves()
  }
}